<?php
/* --------------------------------------------------------------
   WithdrawalIds.php 2020-01-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Models;

use ArrayIterator;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalId;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalIds as WithdrawalIdsInterface;
use Traversable;
use Webmozart\Assert\Assert;

/**
 * Class WithdrawalIds
 *
 * @package Gambio\Admin\Withdrawal\Models
 */
class WithdrawalIds implements WithdrawalIdsInterface
{
    /**
     * @var WithdrawalId[]
     */
    private $ids;
    
    
    /**
     * WithdrawalIds constructor.
     *
     * @param WithdrawalId[] $ids
     */
    private function __construct(array $ids)
    {
        $this->ids = $ids;
    }
    
    
    /**
     * @param WithdrawalId[] $ids
     *
     * @return WithdrawalIds
     */
    public static function create(WithdrawalId...$ids): WithdrawalIds
    {
        return new self($ids);
    }
    
    
    /**
     * @param WithdrawalId[] $ids
     *
     * @return WithdrawalIds
     */
    public static function createWithReferences(array $ids): WithdrawalIds
    {
        Assert::allIsInstanceOf($ids,
                                WithdrawalId::class,
                                'All items in provided list need to implement "' . WithdrawalId::class . '".');
        
        return new self($ids);
    }
    
    
    /**
     * Returns internal withdrawals as array iterator.
     *
     * @return Traversable
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->ids);
    }
    
    
    /**
     * Returns internal withdrawal IDs as array.
     *
     * @return WithdrawalId[]
     */
    public function items(): array
    {
        return $this->ids;
    }
    
    
    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return $this->items();
    }
}